(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7851,        236]*)
(*NotebookOutlinePosition[      8695,        263]*)
(*  CellTagsIndexPosition[      8651,        259]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
    \( (*\ Example\ 3.2  .1 . \ Baker\ 1978, \ 
      p . \ 766\ *) \[IndentingNewLine] (*\ \[Lambda] = \(-12\), \ h = 1/5, \ 
      1/10, \ 1/20\ *) \[IndentingNewLine] (*\ 
      Use\ formula\ \((2.2  .10)\)\ *) \[IndentingNewLine]\(\[Lambda] = \
\(-12.0\);\)\), "\[IndentingNewLine]", 
    \(\(a = 1.  + \[Lambda]\ h/2;\)\), "\[IndentingNewLine]", 
    \(\(b = 1.  - \[Lambda]\ h/2;\)\), "\[IndentingNewLine]", 
    \(\(\[Gamma] = a/b;\)\), "\[IndentingNewLine]", 
    \(\(f[x_] := \ 13*Exp[x] - 12;\)\), "\[IndentingNewLine]", 
    \(phitil[0] = f[0]\)}], "Input"],

Cell[BoxData[
    \(1\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(h = 1/5;\)\), "\[IndentingNewLine]", 
    \(phitil[
        h] = \[Gamma]*phitil[0] + \((f[h] - f[0])\)/
          b\), "\[IndentingNewLine]", 
    \(phitil[
        2  h] = \[Gamma]*phitil[h] + \((f[2\ h] - f[h])\)/
          b\), "\[IndentingNewLine]", 
    \(phitil[
        3\ h] = \[Gamma]*phitil[2\ h] + \((f[3\ h] - f[2\ h])\)/
          b\), "\[IndentingNewLine]", 
    \(phitil[
        4\ h] = \[Gamma]*phitil[3\ h] + \((f[4\ h] - \ f[3\ h])\)/
          b\), "\[IndentingNewLine]", 
    \(phitil[
        5\ h] = \[Gamma]*phitil[4\ h] + \((f[5\ h] - f[4\ h])\)/b\)}], "Input"],

Cell[BoxData[
    \(1.2173799345828218`\)], "Output"],

Cell[BoxData[
    \(1.4872769210626118`\)], "Output"],

Cell[BoxData[
    \(1.81653088705799`\)], "Output"],

Cell[BoxData[
    \(2.2187188581426684`\)], "Output"],

Cell[BoxData[
    \(2.709949058153165`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Clear[h];\)\), "\[IndentingNewLine]", 
    \(\(h = 1/10;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          h] = \[Gamma]*phitil[0] + \((f[h] - f[0])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(phitil[
        2  h] = \[Gamma]*phitil[h] + \((f[2\ h] - f[h])\)/
          b\), "\[IndentingNewLine]", 
    \(\(phitil[
          3\ h] = \[Gamma]*phitil[2\ h] + \((f[3\ h] - f[2\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(phitil[
        4\ h] = \[Gamma]*phitil[3\ h] + \((f[4\ h] - \ f[3\ h])\)/
          b\), "\[IndentingNewLine]", 
    \(\(phitil[
          5\ h] = \[Gamma]*phitil[4\ h] + \((f[5\ h] - f[4\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(phitil[
        6\ h] = \[Gamma]*phitil[5\ h] + \((f[6\ h] - f[5\ h])\)/
          b\), "\[IndentingNewLine]", 
    \(\(phitil[
          7\ h] = \[Gamma]*phitil[6\ h] + \((f[7\ h] - f[6\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(phitil[
        8\ h] = \[Gamma]*phitil[7\ h] + \((f[8\ h] - f[7\ h])\)/
          b\), "\[IndentingNewLine]", 
    \(\(phitil[
          9\ h] = \[Gamma]*phitil[8\ h] + \((f[9\ h] - f[8\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(phitil[
        10\ h] = \[Gamma]*phitil[9\ h] + \((f[10\ h] - f[9\ h])\)/
          b\)}], "Input"],

Cell[BoxData[
    \(1.220512128027903`\)], "Output"],

Cell[BoxData[
    \(1.490681215157955`\)], "Output"],

Cell[BoxData[
    \(1.8207186687075212`\)], "Output"],

Cell[BoxData[
    \(2.2238305863540915`\)], "Output"],

Cell[BoxData[
    \(2.716192798263889`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Clear[h];\)\), "\[IndentingNewLine]", 
    \(\(h = 1/20;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          h] = \[Gamma]*phitil[0] + \((f[h] - f[0])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          2  h] = \[Gamma]*phitil[h] + \((f[2\ h] - f[h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          3\ h] = \[Gamma]*phitil[2\ h] + \((f[3\ h] - f[2\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(phitil[
        4\ h] = \[Gamma]*phitil[3\ h] + \((f[4\ h] - \ f[3\ h])\)/
          b\), "\[IndentingNewLine]", 
    \(\(phitil[
          5\ h] = \[Gamma]*phitil[4\ h] + \((f[5\ h] - f[4\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          6\ h] = \[Gamma]*phitil[5\ h] + \((f[6\ h] - f[5\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          7\ h] = \[Gamma]*phitil[6\ h] + \((f[7\ h] - f[6\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(phitil[
        8\ h] = \[Gamma]*phitil[7\ h] + \((f[8\ h] - f[7\ h])\)/
          b\), "\[IndentingNewLine]", 
    \(\(phitil[
          9\ h] = \[Gamma]*phitil[8\ h] + \((f[9\ h] - f[8\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          10\ h] = \[Gamma]*phitil[9\ h] + \((f[10\ h] - f[9\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          11\ h] = \[Gamma]*phitil[10\ h] + \((f[11\ h] - f[10\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(phitil[
        12\ h] = \[Gamma]*phitil[11\ h] + \((f[12\ h] - f[11\ h])\)/
          b\), "\[IndentingNewLine]", 
    \(\(phitil[
          13\ h] = \[Gamma]*phitil[12\ h] + \((f[13\ h] - f[12\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          14\ h] = \[Gamma]*phitil[13\ h] + \((f[14\ h] - f[13\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          15\ h] = \[Gamma]*phitil[14\ h] + \((f[15\ h] - f[14\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(phitil[
        16\ h] = \[Gamma]*phitil[15\ h] + \((f[16\ h] - f[15\ h])\)/
          b\), "\[IndentingNewLine]", 
    \(\(phitil[
          17\ h] = \[Gamma]*phitil[16\ h] + \((f[17\ h] - f[16\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          18\ h] = \[Gamma]*phitil[17\ h] + \((f[18\ h] - f[17\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          19\ h] = \[Gamma]*phitil[18\ h] + \((f[19\ h] - f[18\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(phitil[
        20\ h] = \[Gamma]*phitil[19\ h] + \((f[20\ h] - f[19\ h])\)/
          b\)}], "Input"],

Cell[BoxData[
    \(1.2211840906544842`\)], "Output"],

Cell[BoxData[
    \(1.4915392341132803`\)], "Output"],

Cell[BoxData[
    \(1.821768589118228`\)], "Output"],

Cell[BoxData[
    \(2.225113049569191`\)], "Output"],

Cell[BoxData[
    \(2.7177592050410717`\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 482},
WindowMargins->{{33, Automatic}, {12, Automatic}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 583, 10, 155, "Input"],
Cell[2325, 63, 35, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2397, 69, 610, 15, 107, "Input"],
Cell[3010, 86, 53, 1, 26, "Output"],
Cell[3066, 89, 53, 1, 26, "Output"],
Cell[3122, 92, 51, 1, 26, "Output"],
Cell[3176, 95, 53, 1, 26, "Output"],
Cell[3232, 98, 52, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3321, 104, 1306, 32, 203, "Input"],
Cell[4630, 138, 52, 1, 26, "Output"],
Cell[4685, 141, 52, 1, 26, "Output"],
Cell[4740, 144, 53, 1, 26, "Output"],
Cell[4796, 147, 53, 1, 26, "Output"],
Cell[4852, 150, 52, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4941, 156, 2616, 62, 363, "Input"],
Cell[7560, 220, 53, 1, 26, "Output"],
Cell[7616, 223, 53, 1, 26, "Output"],
Cell[7672, 226, 52, 1, 26, "Output"],
Cell[7727, 229, 52, 1, 26, "Output"],
Cell[7782, 232, 53, 1, 26, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

